%------------------------------------------------------------------------------
% File     : DAT167^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Data Structures
% Problem  : Huffman 1213
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [Bla08] Blanchette (2008), The Textbook Proof of Huffman's Alg
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : huffman__1213.p [Bla16]

% Status   : Theorem
% Rating   : 1.00 v7.1.0
% Syntax   : Number of formulae    :  360 ( 128 unt;  53 typ;   0 def)
%            Number of atoms       :  801 ( 268 equ;   0 cnn)
%            Maximal formula atoms :   13 (   2 avg)
%            Number of connectives : 3849 (  64   ~;  11   |;  50   &;3396   @)
%                                         (   0 <=>; 328  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   18 (   7 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :  192 ( 192   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   52 (  51 usr;   5 con; 0-6 aty)
%            Number of variables   : 1009 (  67   ^; 890   !;   8   ?;1009   :)
%                                         (  44  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:40:52.298
%------------------------------------------------------------------------------
%----Could-be-implicit typings (5)
thf(ty_t_Huffman__Mirabelle__gjololrwrm_Otree,type,
    huffma16452318e_tree: $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

thf(ty_tf_a,type,
    a: $tType ).

%----Explicit typings (48)
thf(sy_cl_Lattices_Obounded__lattice,type,
    bounded_lattice: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ominus,type,
    minus: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ouminus,type,
    uminus: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Olattice,type,
    lattice: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oorder__bot,type,
    order_bot: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Oboolean__algebra,type,
    boolean_algebra: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Osemilattice__sup,type,
    semilattice_sup: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Obounded__lattice__bot,type,
    bounded_lattice_bot: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Obounded__semilattice__sup__bot,type,
    bounde1808546759up_bot: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Omonoid,type,
    monoid: 
      !>[A: $tType] : ( ( A > A > A ) > A > $o ) ).

thf(sy_c_Groups_Omonoid__axioms,type,
    monoid_axioms: 
      !>[A: $tType] : ( ( A > A > A ) > A > $o ) ).

thf(sy_c_Groups_Osemigroup,type,
    semigroup: 
      !>[A: $tType] : ( ( A > A > A ) > $o ) ).

thf(sy_c_Groups_Ouminus__class_Ouminus,type,
    uminus_uminus: 
      !>[A: $tType] : ( A > A ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Oalphabet,type,
    huffma505251170phabet: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > ( set @ A ) ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_OswapLeaves,type,
    huffma2094459102Leaves: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > nat > A > nat > A > ( huffma16452318e_tree @ A ) ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Otree_OLeaf,type,
    huffma1554276827e_Leaf: 
      !>[A: $tType] : ( nat > A > ( huffma16452318e_tree @ A ) ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Otree_Oset__tree,type,
    huffma778495363t_tree: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > ( set @ A ) ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_OuniteTrees,type,
    huffma453905539eTrees: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > ( huffma16452318e_tree @ A ) > ( huffma16452318e_tree @ A ) ) ).

thf(sy_c_Lattices_Osemilattice__neutr,type,
    semilattice_neutr: 
      !>[A: $tType] : ( ( A > A > A ) > A > $o ) ).

thf(sy_c_Lattices_Osup__class_Osup,type,
    sup_sup: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

thf(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Pure_Otype,type,
    type2: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Relation_Oinv__imagep,type,
    inv_imagep: 
      !>[B: $tType,A: $tType] : ( ( B > B > $o ) > ( A > B ) > A > A > $o ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( A > ( set @ A ) > ( set @ A ) ) ).

thf(sy_c_Set_Ois__empty,type,
    is_empty: 
      !>[A: $tType] : ( ( set @ A ) > $o ) ).

thf(sy_c_Set_Ois__singleton,type,
    is_singleton: 
      !>[A: $tType] : ( ( set @ A ) > $o ) ).

thf(sy_c_Set_Opairwise,type,
    pairwise: 
      !>[A: $tType] : ( ( A > A > $o ) > ( set @ A ) > $o ) ).

thf(sy_c_Set_Oremove,type,
    remove: 
      !>[A: $tType] : ( A > ( set @ A ) > ( set @ A ) ) ).

thf(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( ( set @ A ) > A ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_a,type,
    a2: a ).

thf(sy_v_b,type,
    b: a ).

thf(sy_v_t,type,
    t: huffma16452318e_tree @ a ).

thf(sy_v_w_092_060_094sub_062a,type,
    w_a: nat ).

thf(sy_v_w_092_060_094sub_062b,type,
    w_b: nat ).

%----Relevant facts (256)
thf(fact_0_swapLeaves__id__when__notin__alphabet,axiom,
    ! [A: $tType,A2: A,T: huffma16452318e_tree @ A,W: nat,W2: nat] :
      ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
     => ( ( huffma2094459102Leaves @ A @ T @ W @ A2 @ W2 @ A2 )
        = T ) ) ).

% swapLeaves_id_when_notin_alphabet
thf(fact_1_exists__in__alphabet,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A] :
    ? [A3: A] : ( member @ A @ A3 @ ( huffma505251170phabet @ A @ T ) ) ).

% exists_in_alphabet
thf(fact_2_insert__Diff__single,axiom,
    ! [A: $tType,A2: A,A4: set @ A] :
      ( ( insert @ A @ A2 @ ( minus_minus @ ( set @ A ) @ A4 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) )
      = ( insert @ A @ A2 @ A4 ) ) ).

% insert_Diff_single
thf(fact_3_Un__Diff__cancel,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A4 @ ( minus_minus @ ( set @ A ) @ B2 @ A4 ) )
      = ( sup_sup @ ( set @ A ) @ A4 @ B2 ) ) ).

% Un_Diff_cancel
thf(fact_4_Un__Diff__cancel2,axiom,
    ! [A: $tType,B2: set @ A,A4: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ B2 @ A4 ) @ A4 )
      = ( sup_sup @ ( set @ A ) @ B2 @ A4 ) ) ).

% Un_Diff_cancel2
thf(fact_5_Diff__insert0,axiom,
    ! [A: $tType,X: A,A4: set @ A,B2: set @ A] :
      ( ~ ( member @ A @ X @ A4 )
     => ( ( minus_minus @ ( set @ A ) @ A4 @ ( insert @ A @ X @ B2 ) )
        = ( minus_minus @ ( set @ A ) @ A4 @ B2 ) ) ) ).

% Diff_insert0
thf(fact_6_insert__Diff1,axiom,
    ! [A: $tType,X: A,B2: set @ A,A4: set @ A] :
      ( ( member @ A @ X @ B2 )
     => ( ( minus_minus @ ( set @ A ) @ ( insert @ A @ X @ A4 ) @ B2 )
        = ( minus_minus @ ( set @ A ) @ A4 @ B2 ) ) ) ).

% insert_Diff1
thf(fact_7_Un__insert__left,axiom,
    ! [A: $tType,A2: A,B2: set @ A,C: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( insert @ A @ A2 @ B2 ) @ C )
      = ( insert @ A @ A2 @ ( sup_sup @ ( set @ A ) @ B2 @ C ) ) ) ).

% Un_insert_left
thf(fact_8_Un__insert__right,axiom,
    ! [A: $tType,A4: set @ A,A2: A,B2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A4 @ ( insert @ A @ A2 @ B2 ) )
      = ( insert @ A @ A2 @ ( sup_sup @ ( set @ A ) @ A4 @ B2 ) ) ) ).

% Un_insert_right
thf(fact_9_Diff__empty,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ A4 @ ( bot_bot @ ( set @ A ) ) )
      = A4 ) ).

% Diff_empty
thf(fact_10_empty__Diff,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ ( bot_bot @ ( set @ A ) ) @ A4 )
      = ( bot_bot @ ( set @ A ) ) ) ).

% empty_Diff
thf(fact_11_Diff__cancel,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ A4 @ A4 )
      = ( bot_bot @ ( set @ A ) ) ) ).

% Diff_cancel
thf(fact_12_Un__empty,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A] :
      ( ( ( sup_sup @ ( set @ A ) @ A4 @ B2 )
        = ( bot_bot @ ( set @ A ) ) )
      = ( ( A4
          = ( bot_bot @ ( set @ A ) ) )
        & ( B2
          = ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Un_empty
thf(fact_13_singletonI,axiom,
    ! [A: $tType,A2: A] : ( member @ A @ A2 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% singletonI
thf(fact_14_empty__Collect__eq,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( ( bot_bot @ ( set @ A ) )
        = ( collect @ A @ P ) )
      = ( ! [X2: A] :
            ~ ( P @ X2 ) ) ) ).

% empty_Collect_eq
thf(fact_15_Collect__empty__eq,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( ( collect @ A @ P )
        = ( bot_bot @ ( set @ A ) ) )
      = ( ! [X2: A] :
            ~ ( P @ X2 ) ) ) ).

% Collect_empty_eq
thf(fact_16_all__not__in__conv,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( ! [X2: A] :
            ~ ( member @ A @ X2 @ A4 ) )
      = ( A4
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% all_not_in_conv
thf(fact_17_empty__iff,axiom,
    ! [A: $tType,C2: A] :
      ~ ( member @ A @ C2 @ ( bot_bot @ ( set @ A ) ) ) ).

% empty_iff
thf(fact_18_insert__absorb2,axiom,
    ! [A: $tType,X: A,A4: set @ A] :
      ( ( insert @ A @ X @ ( insert @ A @ X @ A4 ) )
      = ( insert @ A @ X @ A4 ) ) ).

% insert_absorb2
thf(fact_19_insert__iff,axiom,
    ! [A: $tType,A2: A,B3: A,A4: set @ A] :
      ( ( member @ A @ A2 @ ( insert @ A @ B3 @ A4 ) )
      = ( ( A2 = B3 )
        | ( member @ A @ A2 @ A4 ) ) ) ).

% insert_iff
thf(fact_20_insertCI,axiom,
    ! [A: $tType,A2: A,B2: set @ A,B3: A] :
      ( ( ~ ( member @ A @ A2 @ B2 )
       => ( A2 = B3 ) )
     => ( member @ A @ A2 @ ( insert @ A @ B3 @ B2 ) ) ) ).

% insertCI
thf(fact_21_Un__iff,axiom,
    ! [A: $tType,C2: A,A4: set @ A,B2: set @ A] :
      ( ( member @ A @ C2 @ ( sup_sup @ ( set @ A ) @ A4 @ B2 ) )
      = ( ( member @ A @ C2 @ A4 )
        | ( member @ A @ C2 @ B2 ) ) ) ).

% Un_iff
thf(fact_22_UnCI,axiom,
    ! [A: $tType,C2: A,B2: set @ A,A4: set @ A] :
      ( ( ~ ( member @ A @ C2 @ B2 )
       => ( member @ A @ C2 @ A4 ) )
     => ( member @ A @ C2 @ ( sup_sup @ ( set @ A ) @ A4 @ B2 ) ) ) ).

% UnCI
thf(fact_23_Diff__idemp,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A4 @ B2 ) @ B2 )
      = ( minus_minus @ ( set @ A ) @ A4 @ B2 ) ) ).

% Diff_idemp
thf(fact_24_Diff__iff,axiom,
    ! [A: $tType,C2: A,A4: set @ A,B2: set @ A] :
      ( ( member @ A @ C2 @ ( minus_minus @ ( set @ A ) @ A4 @ B2 ) )
      = ( ( member @ A @ C2 @ A4 )
        & ~ ( member @ A @ C2 @ B2 ) ) ) ).

% Diff_iff
thf(fact_25_DiffI,axiom,
    ! [A: $tType,C2: A,A4: set @ A,B2: set @ A] :
      ( ( member @ A @ C2 @ A4 )
     => ( ~ ( member @ A @ C2 @ B2 )
       => ( member @ A @ C2 @ ( minus_minus @ ( set @ A ) @ A4 @ B2 ) ) ) ) ).

% DiffI
thf(fact_26_ex__in__conv,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( ? [X2: A] : ( member @ A @ X2 @ A4 ) )
      = ( A4
       != ( bot_bot @ ( set @ A ) ) ) ) ).

% ex_in_conv
thf(fact_27_equals0I,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ! [Y: A] :
          ~ ( member @ A @ Y @ A4 )
     => ( A4
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% equals0I
thf(fact_28_equals0D,axiom,
    ! [A: $tType,A4: set @ A,A2: A] :
      ( ( A4
        = ( bot_bot @ ( set @ A ) ) )
     => ~ ( member @ A @ A2 @ A4 ) ) ).

% equals0D
thf(fact_29_emptyE,axiom,
    ! [A: $tType,A2: A] :
      ~ ( member @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ).

% emptyE
thf(fact_30_mk__disjoint__insert,axiom,
    ! [A: $tType,A2: A,A4: set @ A] :
      ( ( member @ A @ A2 @ A4 )
     => ? [B4: set @ A] :
          ( ( A4
            = ( insert @ A @ A2 @ B4 ) )
          & ~ ( member @ A @ A2 @ B4 ) ) ) ).

% mk_disjoint_insert
thf(fact_31_insert__commute,axiom,
    ! [A: $tType,X: A,Y2: A,A4: set @ A] :
      ( ( insert @ A @ X @ ( insert @ A @ Y2 @ A4 ) )
      = ( insert @ A @ Y2 @ ( insert @ A @ X @ A4 ) ) ) ).

% insert_commute
thf(fact_32_insert__eq__iff,axiom,
    ! [A: $tType,A2: A,A4: set @ A,B3: A,B2: set @ A] :
      ( ~ ( member @ A @ A2 @ A4 )
     => ( ~ ( member @ A @ B3 @ B2 )
       => ( ( ( insert @ A @ A2 @ A4 )
            = ( insert @ A @ B3 @ B2 ) )
          = ( ( ( A2 = B3 )
             => ( A4 = B2 ) )
            & ( ( A2 != B3 )
             => ? [C3: set @ A] :
                  ( ( A4
                    = ( insert @ A @ B3 @ C3 ) )
                  & ~ ( member @ A @ B3 @ C3 )
                  & ( B2
                    = ( insert @ A @ A2 @ C3 ) )
                  & ~ ( member @ A @ A2 @ C3 ) ) ) ) ) ) ) ).

% insert_eq_iff
thf(fact_33_insert__absorb,axiom,
    ! [A: $tType,A2: A,A4: set @ A] :
      ( ( member @ A @ A2 @ A4 )
     => ( ( insert @ A @ A2 @ A4 )
        = A4 ) ) ).

% insert_absorb
thf(fact_34_insert__ident,axiom,
    ! [A: $tType,X: A,A4: set @ A,B2: set @ A] :
      ( ~ ( member @ A @ X @ A4 )
     => ( ~ ( member @ A @ X @ B2 )
       => ( ( ( insert @ A @ X @ A4 )
            = ( insert @ A @ X @ B2 ) )
          = ( A4 = B2 ) ) ) ) ).

% insert_ident
thf(fact_35_Set_Oset__insert,axiom,
    ! [A: $tType,X: A,A4: set @ A] :
      ( ( member @ A @ X @ A4 )
     => ~ ! [B4: set @ A] :
            ( ( A4
              = ( insert @ A @ X @ B4 ) )
           => ( member @ A @ X @ B4 ) ) ) ).

% Set.set_insert
thf(fact_36_insertI2,axiom,
    ! [A: $tType,A2: A,B2: set @ A,B3: A] :
      ( ( member @ A @ A2 @ B2 )
     => ( member @ A @ A2 @ ( insert @ A @ B3 @ B2 ) ) ) ).

% insertI2
thf(fact_37_insertI1,axiom,
    ! [A: $tType,A2: A,B2: set @ A] : ( member @ A @ A2 @ ( insert @ A @ A2 @ B2 ) ) ).

% insertI1
thf(fact_38_insertE,axiom,
    ! [A: $tType,A2: A,B3: A,A4: set @ A] :
      ( ( member @ A @ A2 @ ( insert @ A @ B3 @ A4 ) )
     => ( ( A2 != B3 )
       => ( member @ A @ A2 @ A4 ) ) ) ).

% insertE
thf(fact_39_Un__left__commute,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A,C: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A4 @ ( sup_sup @ ( set @ A ) @ B2 @ C ) )
      = ( sup_sup @ ( set @ A ) @ B2 @ ( sup_sup @ ( set @ A ) @ A4 @ C ) ) ) ).

% Un_left_commute
thf(fact_40_Un__left__absorb,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A4 @ ( sup_sup @ ( set @ A ) @ A4 @ B2 ) )
      = ( sup_sup @ ( set @ A ) @ A4 @ B2 ) ) ).

% Un_left_absorb
thf(fact_41_Un__commute,axiom,
    ! [A: $tType] :
      ( ( sup_sup @ ( set @ A ) )
      = ( ^ [A5: set @ A,B5: set @ A] : ( sup_sup @ ( set @ A ) @ B5 @ A5 ) ) ) ).

% Un_commute
thf(fact_42_Un__absorb,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A4 @ A4 )
      = A4 ) ).

% Un_absorb
thf(fact_43_Un__assoc,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A,C: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( sup_sup @ ( set @ A ) @ A4 @ B2 ) @ C )
      = ( sup_sup @ ( set @ A ) @ A4 @ ( sup_sup @ ( set @ A ) @ B2 @ C ) ) ) ).

% Un_assoc
thf(fact_44_ball__Un,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A,P: A > $o] :
      ( ( ! [X2: A] :
            ( ( member @ A @ X2 @ ( sup_sup @ ( set @ A ) @ A4 @ B2 ) )
           => ( P @ X2 ) ) )
      = ( ! [X2: A] :
            ( ( member @ A @ X2 @ A4 )
           => ( P @ X2 ) )
        & ! [X2: A] :
            ( ( member @ A @ X2 @ B2 )
           => ( P @ X2 ) ) ) ) ).

% ball_Un
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( member @ A @ A2 @ ( collect @ A @ P ) )
      = ( P @ A2 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( collect @ A
        @ ^ [X2: A] : ( member @ A @ X2 @ A4 ) )
      = A4 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X3: A] :
          ( ( P @ X3 )
          = ( Q @ X3 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_48_ext,axiom,
    ! [B: $tType,A: $tType,F: A > B,G: A > B] :
      ( ! [X3: A] :
          ( ( F @ X3 )
          = ( G @ X3 ) )
     => ( F = G ) ) ).

% ext
thf(fact_49_bex__Un,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A,P: A > $o] :
      ( ( ? [X2: A] :
            ( ( member @ A @ X2 @ ( sup_sup @ ( set @ A ) @ A4 @ B2 ) )
            & ( P @ X2 ) ) )
      = ( ? [X2: A] :
            ( ( member @ A @ X2 @ A4 )
            & ( P @ X2 ) )
        | ? [X2: A] :
            ( ( member @ A @ X2 @ B2 )
            & ( P @ X2 ) ) ) ) ).

% bex_Un
thf(fact_50_UnI2,axiom,
    ! [A: $tType,C2: A,B2: set @ A,A4: set @ A] :
      ( ( member @ A @ C2 @ B2 )
     => ( member @ A @ C2 @ ( sup_sup @ ( set @ A ) @ A4 @ B2 ) ) ) ).

% UnI2
thf(fact_51_UnI1,axiom,
    ! [A: $tType,C2: A,A4: set @ A,B2: set @ A] :
      ( ( member @ A @ C2 @ A4 )
     => ( member @ A @ C2 @ ( sup_sup @ ( set @ A ) @ A4 @ B2 ) ) ) ).

% UnI1
thf(fact_52_UnE,axiom,
    ! [A: $tType,C2: A,A4: set @ A,B2: set @ A] :
      ( ( member @ A @ C2 @ ( sup_sup @ ( set @ A ) @ A4 @ B2 ) )
     => ( ~ ( member @ A @ C2 @ A4 )
       => ( member @ A @ C2 @ B2 ) ) ) ).

% UnE
thf(fact_53_DiffD2,axiom,
    ! [A: $tType,C2: A,A4: set @ A,B2: set @ A] :
      ( ( member @ A @ C2 @ ( minus_minus @ ( set @ A ) @ A4 @ B2 ) )
     => ~ ( member @ A @ C2 @ B2 ) ) ).

% DiffD2
thf(fact_54_DiffD1,axiom,
    ! [A: $tType,C2: A,A4: set @ A,B2: set @ A] :
      ( ( member @ A @ C2 @ ( minus_minus @ ( set @ A ) @ A4 @ B2 ) )
     => ( member @ A @ C2 @ A4 ) ) ).

% DiffD1
thf(fact_55_DiffE,axiom,
    ! [A: $tType,C2: A,A4: set @ A,B2: set @ A] :
      ( ( member @ A @ C2 @ ( minus_minus @ ( set @ A ) @ A4 @ B2 ) )
     => ~ ( ( member @ A @ C2 @ A4 )
         => ( member @ A @ C2 @ B2 ) ) ) ).

% DiffE
thf(fact_56_singleton__inject,axiom,
    ! [A: $tType,A2: A,B3: A] :
      ( ( ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) )
        = ( insert @ A @ B3 @ ( bot_bot @ ( set @ A ) ) ) )
     => ( A2 = B3 ) ) ).

% singleton_inject
thf(fact_57_insert__not__empty,axiom,
    ! [A: $tType,A2: A,A4: set @ A] :
      ( ( insert @ A @ A2 @ A4 )
     != ( bot_bot @ ( set @ A ) ) ) ).

% insert_not_empty
thf(fact_58_doubleton__eq__iff,axiom,
    ! [A: $tType,A2: A,B3: A,C2: A,D: A] :
      ( ( ( insert @ A @ A2 @ ( insert @ A @ B3 @ ( bot_bot @ ( set @ A ) ) ) )
        = ( insert @ A @ C2 @ ( insert @ A @ D @ ( bot_bot @ ( set @ A ) ) ) ) )
      = ( ( ( A2 = C2 )
          & ( B3 = D ) )
        | ( ( A2 = D )
          & ( B3 = C2 ) ) ) ) ).

% doubleton_eq_iff
thf(fact_59_singleton__iff,axiom,
    ! [A: $tType,B3: A,A2: A] :
      ( ( member @ A @ B3 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) )
      = ( B3 = A2 ) ) ).

% singleton_iff
thf(fact_60_singletonD,axiom,
    ! [A: $tType,B3: A,A2: A] :
      ( ( member @ A @ B3 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) )
     => ( B3 = A2 ) ) ).

% singletonD
thf(fact_61_Un__empty__right,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A4 @ ( bot_bot @ ( set @ A ) ) )
      = A4 ) ).

% Un_empty_right
thf(fact_62_Un__empty__left,axiom,
    ! [A: $tType,B2: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( bot_bot @ ( set @ A ) ) @ B2 )
      = B2 ) ).

% Un_empty_left
thf(fact_63_insert__Diff__if,axiom,
    ! [A: $tType,X: A,B2: set @ A,A4: set @ A] :
      ( ( ( member @ A @ X @ B2 )
       => ( ( minus_minus @ ( set @ A ) @ ( insert @ A @ X @ A4 ) @ B2 )
          = ( minus_minus @ ( set @ A ) @ A4 @ B2 ) ) )
      & ( ~ ( member @ A @ X @ B2 )
       => ( ( minus_minus @ ( set @ A ) @ ( insert @ A @ X @ A4 ) @ B2 )
          = ( insert @ A @ X @ ( minus_minus @ ( set @ A ) @ A4 @ B2 ) ) ) ) ) ).

% insert_Diff_if
thf(fact_64_Un__Diff,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A,C: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ ( sup_sup @ ( set @ A ) @ A4 @ B2 ) @ C )
      = ( sup_sup @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A4 @ C ) @ ( minus_minus @ ( set @ A ) @ B2 @ C ) ) ) ).

% Un_Diff
thf(fact_65_singleton__Un__iff,axiom,
    ! [A: $tType,X: A,A4: set @ A,B2: set @ A] :
      ( ( ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) )
        = ( sup_sup @ ( set @ A ) @ A4 @ B2 ) )
      = ( ( ( A4
            = ( bot_bot @ ( set @ A ) ) )
          & ( B2
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) )
        | ( ( A4
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) )
          & ( B2
            = ( bot_bot @ ( set @ A ) ) ) )
        | ( ( A4
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) )
          & ( B2
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ) ).

% singleton_Un_iff
thf(fact_66_Un__singleton__iff,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A,X: A] :
      ( ( ( sup_sup @ ( set @ A ) @ A4 @ B2 )
        = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) )
      = ( ( ( A4
            = ( bot_bot @ ( set @ A ) ) )
          & ( B2
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) )
        | ( ( A4
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) )
          & ( B2
            = ( bot_bot @ ( set @ A ) ) ) )
        | ( ( A4
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) )
          & ( B2
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ) ).

% Un_singleton_iff
thf(fact_67_insert__is__Un,axiom,
    ! [A: $tType] :
      ( ( insert @ A )
      = ( ^ [A6: A] : ( sup_sup @ ( set @ A ) @ ( insert @ A @ A6 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% insert_is_Un
thf(fact_68_Diff__insert__absorb,axiom,
    ! [A: $tType,X: A,A4: set @ A] :
      ( ~ ( member @ A @ X @ A4 )
     => ( ( minus_minus @ ( set @ A ) @ ( insert @ A @ X @ A4 ) @ ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) )
        = A4 ) ) ).

% Diff_insert_absorb
thf(fact_69_Diff__insert2,axiom,
    ! [A: $tType,A4: set @ A,A2: A,B2: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ A4 @ ( insert @ A @ A2 @ B2 ) )
      = ( minus_minus @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A4 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) @ B2 ) ) ).

% Diff_insert2
thf(fact_70_insert__Diff,axiom,
    ! [A: $tType,A2: A,A4: set @ A] :
      ( ( member @ A @ A2 @ A4 )
     => ( ( insert @ A @ A2 @ ( minus_minus @ ( set @ A ) @ A4 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) )
        = A4 ) ) ).

% insert_Diff
thf(fact_71_Diff__insert,axiom,
    ! [A: $tType,A4: set @ A,A2: A,B2: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ A4 @ ( insert @ A @ A2 @ B2 ) )
      = ( minus_minus @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A4 @ B2 ) @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Diff_insert
thf(fact_72_sup__bot_Oright__neutral,axiom,
    ! [A: $tType] :
      ( ( bounde1808546759up_bot @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( sup_sup @ A @ A2 @ ( bot_bot @ A ) )
          = A2 ) ) ).

% sup_bot.right_neutral
thf(fact_73_sup__bot_Oleft__neutral,axiom,
    ! [A: $tType] :
      ( ( bounde1808546759up_bot @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( sup_sup @ A @ ( bot_bot @ A ) @ A2 )
          = A2 ) ) ).

% sup_bot.left_neutral
thf(fact_74_sup__eq__bot__iff,axiom,
    ! [A: $tType] :
      ( ( bounded_lattice_bot @ A @ ( type2 @ A ) )
     => ! [X: A,Y2: A] :
          ( ( ( sup_sup @ A @ X @ Y2 )
            = ( bot_bot @ A ) )
          = ( ( X
              = ( bot_bot @ A ) )
            & ( Y2
              = ( bot_bot @ A ) ) ) ) ) ).

% sup_eq_bot_iff
thf(fact_75_bot__eq__sup__iff,axiom,
    ! [A: $tType] :
      ( ( bounded_lattice_bot @ A @ ( type2 @ A ) )
     => ! [X: A,Y2: A] :
          ( ( ( bot_bot @ A )
            = ( sup_sup @ A @ X @ Y2 ) )
          = ( ( X
              = ( bot_bot @ A ) )
            & ( Y2
              = ( bot_bot @ A ) ) ) ) ) ).

% bot_eq_sup_iff
thf(fact_76_sup_Oright__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A] :
          ( ( sup_sup @ A @ ( sup_sup @ A @ A2 @ B3 ) @ B3 )
          = ( sup_sup @ A @ A2 @ B3 ) ) ) ).

% sup.right_idem
thf(fact_77_sup__left__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [X: A,Y2: A] :
          ( ( sup_sup @ A @ X @ ( sup_sup @ A @ X @ Y2 ) )
          = ( sup_sup @ A @ X @ Y2 ) ) ) ).

% sup_left_idem
thf(fact_78_sup_Oleft__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A] :
          ( ( sup_sup @ A @ A2 @ ( sup_sup @ A @ A2 @ B3 ) )
          = ( sup_sup @ A @ A2 @ B3 ) ) ) ).

% sup.left_idem
thf(fact_79_sup__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [X: A] :
          ( ( sup_sup @ A @ X @ X )
          = X ) ) ).

% sup_idem
thf(fact_80_sup_Oidem,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( sup_sup @ A @ A2 @ A2 )
          = A2 ) ) ).

% sup.idem
thf(fact_81_sup__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( ( semilattice_sup @ B @ ( type2 @ B ) )
     => ( ( sup_sup @ ( A > B ) )
        = ( ^ [F2: A > B,G2: A > B,X2: A] : ( sup_sup @ B @ ( F2 @ X2 ) @ ( G2 @ X2 ) ) ) ) ) ).

% sup_apply
thf(fact_82_the__elem__eq,axiom,
    ! [A: $tType,X: A] :
      ( ( the_elem @ A @ ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) )
      = X ) ).

% the_elem_eq
thf(fact_83_minus__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( ( minus @ B @ ( type2 @ B ) )
     => ( ( minus_minus @ ( A > B ) )
        = ( ^ [A5: A > B,B5: A > B,X2: A] : ( minus_minus @ B @ ( A5 @ X2 ) @ ( B5 @ X2 ) ) ) ) ) ).

% minus_apply
thf(fact_84_bot__set__def,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( set @ A ) )
      = ( collect @ A @ ( bot_bot @ ( A > $o ) ) ) ) ).

% bot_set_def
thf(fact_85_fun__diff__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( minus @ B @ ( type2 @ B ) )
     => ( ( minus_minus @ ( A > B ) )
        = ( ^ [A5: A > B,B5: A > B,X2: A] : ( minus_minus @ B @ ( A5 @ X2 ) @ ( B5 @ X2 ) ) ) ) ) ).

% fun_diff_def
thf(fact_86_inf__sup__aci_I8_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X: A,Y2: A] :
          ( ( sup_sup @ A @ X @ ( sup_sup @ A @ X @ Y2 ) )
          = ( sup_sup @ A @ X @ Y2 ) ) ) ).

% inf_sup_aci(8)
thf(fact_87_inf__sup__aci_I7_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X: A,Y2: A,Z: A] :
          ( ( sup_sup @ A @ X @ ( sup_sup @ A @ Y2 @ Z ) )
          = ( sup_sup @ A @ Y2 @ ( sup_sup @ A @ X @ Z ) ) ) ) ).

% inf_sup_aci(7)
thf(fact_88_inf__sup__aci_I6_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X: A,Y2: A,Z: A] :
          ( ( sup_sup @ A @ ( sup_sup @ A @ X @ Y2 ) @ Z )
          = ( sup_sup @ A @ X @ ( sup_sup @ A @ Y2 @ Z ) ) ) ) ).

% inf_sup_aci(6)
thf(fact_89_inf__sup__aci_I5_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ( ( sup_sup @ A )
        = ( ^ [X2: A,Y3: A] : ( sup_sup @ A @ Y3 @ X2 ) ) ) ) ).

% inf_sup_aci(5)
thf(fact_90_sup__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( semilattice_sup @ B @ ( type2 @ B ) )
     => ( ( sup_sup @ ( A > B ) )
        = ( ^ [F2: A > B,G2: A > B,X2: A] : ( sup_sup @ B @ ( F2 @ X2 ) @ ( G2 @ X2 ) ) ) ) ) ).

% sup_fun_def
thf(fact_91_sup_Oassoc,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A,C2: A] :
          ( ( sup_sup @ A @ ( sup_sup @ A @ A2 @ B3 ) @ C2 )
          = ( sup_sup @ A @ A2 @ ( sup_sup @ A @ B3 @ C2 ) ) ) ) ).

% sup.assoc
thf(fact_92_sup__assoc,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [X: A,Y2: A,Z: A] :
          ( ( sup_sup @ A @ ( sup_sup @ A @ X @ Y2 ) @ Z )
          = ( sup_sup @ A @ X @ ( sup_sup @ A @ Y2 @ Z ) ) ) ) ).

% sup_assoc
thf(fact_93_sup_Ocommute,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ( ( sup_sup @ A )
        = ( ^ [A6: A,B6: A] : ( sup_sup @ A @ B6 @ A6 ) ) ) ) ).

% sup.commute
thf(fact_94_sup__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ( ( sup_sup @ A )
        = ( ^ [X2: A,Y3: A] : ( sup_sup @ A @ Y3 @ X2 ) ) ) ) ).

% sup_commute
thf(fact_95_sup_Oleft__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [B3: A,A2: A,C2: A] :
          ( ( sup_sup @ A @ B3 @ ( sup_sup @ A @ A2 @ C2 ) )
          = ( sup_sup @ A @ A2 @ ( sup_sup @ A @ B3 @ C2 ) ) ) ) ).

% sup.left_commute
thf(fact_96_sup__left__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [X: A,Y2: A,Z: A] :
          ( ( sup_sup @ A @ X @ ( sup_sup @ A @ Y2 @ Z ) )
          = ( sup_sup @ A @ Y2 @ ( sup_sup @ A @ X @ Z ) ) ) ) ).

% sup_left_commute
thf(fact_97_sup__bot__left,axiom,
    ! [A: $tType] :
      ( ( bounded_lattice_bot @ A @ ( type2 @ A ) )
     => ! [X: A] :
          ( ( sup_sup @ A @ ( bot_bot @ A ) @ X )
          = X ) ) ).

% sup_bot_left
thf(fact_98_sup__bot__right,axiom,
    ! [A: $tType] :
      ( ( bounded_lattice_bot @ A @ ( type2 @ A ) )
     => ! [X: A] :
          ( ( sup_sup @ A @ X @ ( bot_bot @ A ) )
          = X ) ) ).

% sup_bot_right
thf(fact_99_bot__apply,axiom,
    ! [C4: $tType,D2: $tType] :
      ( ( bot @ C4 @ ( type2 @ C4 ) )
     => ( ( bot_bot @ ( D2 > C4 ) )
        = ( ^ [X2: D2] : ( bot_bot @ C4 ) ) ) ) ).

% bot_apply
thf(fact_100_is__singleton__the__elem,axiom,
    ! [A: $tType] :
      ( ( is_singleton @ A )
      = ( ^ [A5: set @ A] :
            ( A5
            = ( insert @ A @ ( the_elem @ A @ A5 ) @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% is_singleton_the_elem
thf(fact_101_is__singletonI,axiom,
    ! [A: $tType,X: A] : ( is_singleton @ A @ ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) ).

% is_singletonI
thf(fact_102_alphabet__uniteTrees,axiom,
    ! [A: $tType,T_1: huffma16452318e_tree @ A,T_2: huffma16452318e_tree @ A] :
      ( ( huffma505251170phabet @ A @ ( huffma453905539eTrees @ A @ T_1 @ T_2 ) )
      = ( sup_sup @ ( set @ A ) @ ( huffma505251170phabet @ A @ T_1 ) @ ( huffma505251170phabet @ A @ T_2 ) ) ) ).

% alphabet_uniteTrees
thf(fact_103_remove__def,axiom,
    ! [A: $tType] :
      ( ( remove @ A )
      = ( ^ [X2: A,A5: set @ A] : ( minus_minus @ ( set @ A ) @ A5 @ ( insert @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% remove_def
thf(fact_104_Set_Ois__empty__def,axiom,
    ! [A: $tType] :
      ( ( is_empty @ A )
      = ( ^ [A5: set @ A] :
            ( A5
            = ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Set.is_empty_def
thf(fact_105_member__remove,axiom,
    ! [A: $tType,X: A,Y2: A,A4: set @ A] :
      ( ( member @ A @ X @ ( remove @ A @ Y2 @ A4 ) )
      = ( ( member @ A @ X @ A4 )
        & ( X != Y2 ) ) ) ).

% member_remove
thf(fact_106_is__singletonI_H,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( A4
       != ( bot_bot @ ( set @ A ) ) )
     => ( ! [X3: A,Y: A] :
            ( ( member @ A @ X3 @ A4 )
           => ( ( member @ A @ Y @ A4 )
             => ( X3 = Y ) ) )
       => ( is_singleton @ A @ A4 ) ) ) ).

% is_singletonI'
thf(fact_107_bot__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( bot @ B @ ( type2 @ B ) )
     => ( ( bot_bot @ ( A > B ) )
        = ( ^ [X2: A] : ( bot_bot @ B ) ) ) ) ).

% bot_fun_def
thf(fact_108_is__singleton__def,axiom,
    ! [A: $tType] :
      ( ( is_singleton @ A )
      = ( ^ [A5: set @ A] :
          ? [X2: A] :
            ( A5
            = ( insert @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% is_singleton_def
thf(fact_109_is__singletonE,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( is_singleton @ A @ A4 )
     => ~ ! [X3: A] :
            ( A4
           != ( insert @ A @ X3 @ ( bot_bot @ ( set @ A ) ) ) ) ) ).

% is_singletonE
thf(fact_110_Collect__empty__eq__bot,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( ( collect @ A @ P )
        = ( bot_bot @ ( set @ A ) ) )
      = ( P
        = ( bot_bot @ ( A > $o ) ) ) ) ).

% Collect_empty_eq_bot
thf(fact_111_bot__empty__eq,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( A > $o ) )
      = ( ^ [X2: A] : ( member @ A @ X2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ).

% bot_empty_eq
thf(fact_112_pairwise__singleton,axiom,
    ! [A: $tType,P: A > A > $o,A4: A] : ( pairwise @ A @ P @ ( insert @ A @ A4 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% pairwise_singleton
thf(fact_113_alphabet_Osimps_I1_J,axiom,
    ! [A: $tType,W: nat,A2: A] :
      ( ( huffma505251170phabet @ A @ ( huffma1554276827e_Leaf @ A @ W @ A2 ) )
      = ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% alphabet.simps(1)
thf(fact_114_sup__bot_Osemilattice__neutr__axioms,axiom,
    ! [A: $tType] :
      ( ( bounde1808546759up_bot @ A @ ( type2 @ A ) )
     => ( semilattice_neutr @ A @ ( sup_sup @ A ) @ ( bot_bot @ A ) ) ) ).

% sup_bot.semilattice_neutr_axioms
thf(fact_115_tree_Oinject_I1_J,axiom,
    ! [A: $tType,X11: nat,X12: A,Y11: nat,Y12: A] :
      ( ( ( huffma1554276827e_Leaf @ A @ X11 @ X12 )
        = ( huffma1554276827e_Leaf @ A @ Y11 @ Y12 ) )
      = ( ( X11 = Y11 )
        & ( X12 = Y12 ) ) ) ).

% tree.inject(1)
thf(fact_116_pairwise__def,axiom,
    ! [A: $tType] :
      ( ( pairwise @ A )
      = ( ^ [R: A > A > $o,S: set @ A] :
          ! [X2: A] :
            ( ( member @ A @ X2 @ S )
           => ! [Y3: A] :
                ( ( member @ A @ Y3 @ S )
               => ( ( X2 != Y3 )
                 => ( R @ X2 @ Y3 ) ) ) ) ) ) ).

% pairwise_def
thf(fact_117_swapLeaves_Osimps_I1_J,axiom,
    ! [A: $tType,C2: A,A2: A,W_c: nat,W_a: nat,W_b: nat,B3: A] :
      ( ( ( C2 = A2 )
       => ( ( huffma2094459102Leaves @ A @ ( huffma1554276827e_Leaf @ A @ W_c @ C2 ) @ W_a @ A2 @ W_b @ B3 )
          = ( huffma1554276827e_Leaf @ A @ W_b @ B3 ) ) )
      & ( ( C2 != A2 )
       => ( ( ( C2 = B3 )
           => ( ( huffma2094459102Leaves @ A @ ( huffma1554276827e_Leaf @ A @ W_c @ C2 ) @ W_a @ A2 @ W_b @ B3 )
              = ( huffma1554276827e_Leaf @ A @ W_a @ A2 ) ) )
          & ( ( C2 != B3 )
           => ( ( huffma2094459102Leaves @ A @ ( huffma1554276827e_Leaf @ A @ W_c @ C2 ) @ W_a @ A2 @ W_b @ B3 )
              = ( huffma1554276827e_Leaf @ A @ W_c @ C2 ) ) ) ) ) ) ).

% swapLeaves.simps(1)
thf(fact_118_pairwise__empty,axiom,
    ! [A: $tType,P: A > A > $o] : ( pairwise @ A @ P @ ( bot_bot @ ( set @ A ) ) ) ).

% pairwise_empty
thf(fact_119_pairwise__insert,axiom,
    ! [A: $tType,R2: A > A > $o,X: A,S2: set @ A] :
      ( ( pairwise @ A @ R2 @ ( insert @ A @ X @ S2 ) )
      = ( ! [Y3: A] :
            ( ( ( member @ A @ Y3 @ S2 )
              & ( Y3 != X ) )
           => ( ( R2 @ X @ Y3 )
              & ( R2 @ Y3 @ X ) ) )
        & ( pairwise @ A @ R2 @ S2 ) ) ) ).

% pairwise_insert
thf(fact_120_tree_Osimps_I15_J,axiom,
    ! [A: $tType,X11: nat,X12: A] :
      ( ( huffma778495363t_tree @ A @ ( huffma1554276827e_Leaf @ A @ X11 @ X12 ) )
      = ( insert @ A @ X12 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% tree.simps(15)
thf(fact_121_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A,C2: A,D: A] :
          ( ( ( minus_minus @ A @ A2 @ B3 )
            = ( minus_minus @ A @ C2 @ D ) )
         => ( ( A2 = B3 )
            = ( C2 = D ) ) ) ) ).

% diff_eq_diff_eq
thf(fact_122_diff__right__commute,axiom,
    ! [A: $tType] :
      ( ( cancel146912293up_add @ A @ ( type2 @ A ) )
     => ! [A2: A,C2: A,B3: A] :
          ( ( minus_minus @ A @ ( minus_minus @ A @ A2 @ C2 ) @ B3 )
          = ( minus_minus @ A @ ( minus_minus @ A @ A2 @ B3 ) @ C2 ) ) ) ).

% diff_right_commute
thf(fact_123_sup__bot_Omonoid__axioms,axiom,
    ! [A: $tType] :
      ( ( bounde1808546759up_bot @ A @ ( type2 @ A ) )
     => ( monoid @ A @ ( sup_sup @ A ) @ ( bot_bot @ A ) ) ) ).

% sup_bot.monoid_axioms
thf(fact_124_monoid_Oleft__neutral,axiom,
    ! [A: $tType,F: A > A > A,Z: A,A2: A] :
      ( ( monoid @ A @ F @ Z )
     => ( ( F @ Z @ A2 )
        = A2 ) ) ).

% monoid.left_neutral
thf(fact_125_monoid_Oright__neutral,axiom,
    ! [A: $tType,F: A > A > A,Z: A,A2: A] :
      ( ( monoid @ A @ F @ Z )
     => ( ( F @ A2 @ Z )
        = A2 ) ) ).

% monoid.right_neutral
thf(fact_126_tree_Oset__intros_I1_J,axiom,
    ! [A: $tType,A22: A,A1: nat] : ( member @ A @ A22 @ ( huffma778495363t_tree @ A @ ( huffma1554276827e_Leaf @ A @ A1 @ A22 ) ) ) ).

% tree.set_intros(1)
thf(fact_127_monoid_Oaxioms_I2_J,axiom,
    ! [A: $tType,F: A > A > A,Z: A] :
      ( ( monoid @ A @ F @ Z )
     => ( monoid_axioms @ A @ F @ Z ) ) ).

% monoid.axioms(2)
thf(fact_128_Diff__single__insert,axiom,
    ! [A: $tType,A4: set @ A,X: A,B2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A4 @ ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) @ B2 )
     => ( ord_less_eq @ ( set @ A ) @ A4 @ ( insert @ A @ X @ B2 ) ) ) ).

% Diff_single_insert
thf(fact_129_subset__insert__iff,axiom,
    ! [A: $tType,A4: set @ A,X: A,B2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ ( insert @ A @ X @ B2 ) )
      = ( ( ( member @ A @ X @ A4 )
         => ( ord_less_eq @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A4 @ ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) @ B2 ) )
        & ( ~ ( member @ A @ X @ A4 )
         => ( ord_less_eq @ ( set @ A ) @ A4 @ B2 ) ) ) ) ).

% subset_insert_iff
thf(fact_130_in__inv__imagep,axiom,
    ! [B: $tType,A: $tType] :
      ( ( inv_imagep @ A @ B )
      = ( ^ [R3: A > A > $o,F2: B > A,X2: B,Y3: B] : ( R3 @ ( F2 @ X2 ) @ ( F2 @ Y3 ) ) ) ) ).

% in_inv_imagep
thf(fact_131_order__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A] : ( ord_less_eq @ A @ X @ X ) ) ).

% order_refl
thf(fact_132_subsetI,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A] :
      ( ! [X3: A] :
          ( ( member @ A @ X3 @ A4 )
         => ( member @ A @ X3 @ B2 ) )
     => ( ord_less_eq @ ( set @ A ) @ A4 @ B2 ) ) ).

% subsetI
thf(fact_133_subset__antisym,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B2 )
     => ( ( ord_less_eq @ ( set @ A ) @ B2 @ A4 )
       => ( A4 = B2 ) ) ) ).

% subset_antisym
thf(fact_134_le__sup__iff,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [X: A,Y2: A,Z: A] :
          ( ( ord_less_eq @ A @ ( sup_sup @ A @ X @ Y2 ) @ Z )
          = ( ( ord_less_eq @ A @ X @ Z )
            & ( ord_less_eq @ A @ Y2 @ Z ) ) ) ) ).

% le_sup_iff
thf(fact_135_sup_Obounded__iff,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [B3: A,C2: A,A2: A] :
          ( ( ord_less_eq @ A @ ( sup_sup @ A @ B3 @ C2 ) @ A2 )
          = ( ( ord_less_eq @ A @ B3 @ A2 )
            & ( ord_less_eq @ A @ C2 @ A2 ) ) ) ) ).

% sup.bounded_iff
thf(fact_136_subset__empty,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ ( bot_bot @ ( set @ A ) ) )
      = ( A4
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% subset_empty
thf(fact_137_empty__subsetI,axiom,
    ! [A: $tType,A4: set @ A] : ( ord_less_eq @ ( set @ A ) @ ( bot_bot @ ( set @ A ) ) @ A4 ) ).

% empty_subsetI
thf(fact_138_insert__subset,axiom,
    ! [A: $tType,X: A,A4: set @ A,B2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ ( insert @ A @ X @ A4 ) @ B2 )
      = ( ( member @ A @ X @ B2 )
        & ( ord_less_eq @ ( set @ A ) @ A4 @ B2 ) ) ) ).

% insert_subset
thf(fact_139_Un__subset__iff,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A,C: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ ( sup_sup @ ( set @ A ) @ A4 @ B2 ) @ C )
      = ( ( ord_less_eq @ ( set @ A ) @ A4 @ C )
        & ( ord_less_eq @ ( set @ A ) @ B2 @ C ) ) ) ).

% Un_subset_iff
thf(fact_140_singleton__insert__inj__eq,axiom,
    ! [A: $tType,B3: A,A2: A,A4: set @ A] :
      ( ( ( insert @ A @ B3 @ ( bot_bot @ ( set @ A ) ) )
        = ( insert @ A @ A2 @ A4 ) )
      = ( ( A2 = B3 )
        & ( ord_less_eq @ ( set @ A ) @ A4 @ ( insert @ A @ B3 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% singleton_insert_inj_eq
thf(fact_141_singleton__insert__inj__eq_H,axiom,
    ! [A: $tType,A2: A,A4: set @ A,B3: A] :
      ( ( ( insert @ A @ A2 @ A4 )
        = ( insert @ A @ B3 @ ( bot_bot @ ( set @ A ) ) ) )
      = ( ( A2 = B3 )
        & ( ord_less_eq @ ( set @ A ) @ A4 @ ( insert @ A @ B3 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% singleton_insert_inj_eq'
thf(fact_142_Diff__eq__empty__iff,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A] :
      ( ( ( minus_minus @ ( set @ A ) @ A4 @ B2 )
        = ( bot_bot @ ( set @ A ) ) )
      = ( ord_less_eq @ ( set @ A ) @ A4 @ B2 ) ) ).

% Diff_eq_empty_iff
thf(fact_143_monoid__axioms__def,axiom,
    ! [A: $tType] :
      ( ( monoid_axioms @ A )
      = ( ^ [F2: A > A > A,Z2: A] :
            ( ! [A6: A] :
                ( ( F2 @ Z2 @ A6 )
                = A6 )
            & ! [A6: A] :
                ( ( F2 @ A6 @ Z2 )
                = A6 ) ) ) ) ).

% monoid_axioms_def
thf(fact_144_monoid__axioms_Ointro,axiom,
    ! [A: $tType,F: A > A > A,Z: A] :
      ( ! [A3: A] :
          ( ( F @ Z @ A3 )
          = A3 )
     => ( ! [A3: A] :
            ( ( F @ A3 @ Z )
            = A3 )
       => ( monoid_axioms @ A @ F @ Z ) ) ) ).

% monoid_axioms.intro
thf(fact_145_diff__eq__diff__less__eq,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A,C2: A,D: A] :
          ( ( ( minus_minus @ A @ A2 @ B3 )
            = ( minus_minus @ A @ C2 @ D ) )
         => ( ( ord_less_eq @ A @ A2 @ B3 )
            = ( ord_less_eq @ A @ C2 @ D ) ) ) ) ).

% diff_eq_diff_less_eq
thf(fact_146_diff__right__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A,C2: A] :
          ( ( ord_less_eq @ A @ A2 @ B3 )
         => ( ord_less_eq @ A @ ( minus_minus @ A @ A2 @ C2 ) @ ( minus_minus @ A @ B3 @ C2 ) ) ) ) ).

% diff_right_mono
thf(fact_147_diff__left__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [B3: A,A2: A,C2: A] :
          ( ( ord_less_eq @ A @ B3 @ A2 )
         => ( ord_less_eq @ A @ ( minus_minus @ A @ C2 @ A2 ) @ ( minus_minus @ A @ C2 @ B3 ) ) ) ) ).

% diff_left_mono
thf(fact_148_diff__mono,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A,D: A,C2: A] :
          ( ( ord_less_eq @ A @ A2 @ B3 )
         => ( ( ord_less_eq @ A @ D @ C2 )
           => ( ord_less_eq @ A @ ( minus_minus @ A @ A2 @ C2 ) @ ( minus_minus @ A @ B3 @ D ) ) ) ) ) ).

% diff_mono
thf(fact_149_bot_Oextremum,axiom,
    ! [A: $tType] :
      ( ( order_bot @ A @ ( type2 @ A ) )
     => ! [A2: A] : ( ord_less_eq @ A @ ( bot_bot @ A ) @ A2 ) ) ).

% bot.extremum
thf(fact_150_bot_Oextremum__unique,axiom,
    ! [A: $tType] :
      ( ( order_bot @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( ord_less_eq @ A @ A2 @ ( bot_bot @ A ) )
          = ( A2
            = ( bot_bot @ A ) ) ) ) ).

% bot.extremum_unique
thf(fact_151_bot_Oextremum__uniqueI,axiom,
    ! [A: $tType] :
      ( ( order_bot @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( ord_less_eq @ A @ A2 @ ( bot_bot @ A ) )
         => ( A2
            = ( bot_bot @ A ) ) ) ) ).

% bot.extremum_uniqueI
thf(fact_152_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F: A > B,G: A > B,X: A] :
          ( ( ord_less_eq @ ( A > B ) @ F @ G )
         => ( ord_less_eq @ B @ ( F @ X ) @ ( G @ X ) ) ) ) ).

% le_funD
thf(fact_153_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F: A > B,G: A > B,X: A] :
          ( ( ord_less_eq @ ( A > B ) @ F @ G )
         => ( ord_less_eq @ B @ ( F @ X ) @ ( G @ X ) ) ) ) ).

% le_funE
thf(fact_154_le__funI,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F: A > B,G: A > B] :
          ( ! [X3: A] : ( ord_less_eq @ B @ ( F @ X3 ) @ ( G @ X3 ) )
         => ( ord_less_eq @ ( A > B ) @ F @ G ) ) ) ).

% le_funI
thf(fact_155_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ( ( ord_less_eq @ ( A > B ) )
        = ( ^ [F2: A > B,G2: A > B] :
            ! [X2: A] : ( ord_less_eq @ B @ ( F2 @ X2 ) @ ( G2 @ X2 ) ) ) ) ) ).

% le_fun_def
thf(fact_156_order__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B @ ( type2 @ B ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F: B > A,B3: B,C2: B] :
          ( ( ord_less_eq @ A @ A2 @ ( F @ B3 ) )
         => ( ( ord_less_eq @ B @ B3 @ C2 )
           => ( ! [X3: B,Y: B] :
                  ( ( ord_less_eq @ B @ X3 @ Y )
                 => ( ord_less_eq @ A @ ( F @ X3 ) @ ( F @ Y ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F @ C2 ) ) ) ) ) ) ).

% order_subst1
thf(fact_157_order__subst2,axiom,
    ! [A: $tType,C4: $tType] :
      ( ( ( order @ C4 @ ( type2 @ C4 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B3: A,F: A > C4,C2: C4] :
          ( ( ord_less_eq @ A @ A2 @ B3 )
         => ( ( ord_less_eq @ C4 @ ( F @ B3 ) @ C2 )
           => ( ! [X3: A,Y: A] :
                  ( ( ord_less_eq @ A @ X3 @ Y )
                 => ( ord_less_eq @ C4 @ ( F @ X3 ) @ ( F @ Y ) ) )
             => ( ord_less_eq @ C4 @ ( F @ A2 ) @ C2 ) ) ) ) ) ).

% order_subst2
thf(fact_158_ord__eq__le__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F: B > A,B3: B,C2: B] :
          ( ( A2
            = ( F @ B3 ) )
         => ( ( ord_less_eq @ B @ B3 @ C2 )
           => ( ! [X3: B,Y: B] :
                  ( ( ord_less_eq @ B @ X3 @ Y )
                 => ( ord_less_eq @ A @ ( F @ X3 ) @ ( F @ Y ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F @ C2 ) ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_159_ord__le__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B3: A,F: A > B,C2: B] :
          ( ( ord_less_eq @ A @ A2 @ B3 )
         => ( ( ( F @ B3 )
              = C2 )
           => ( ! [X3: A,Y: A] :
                  ( ( ord_less_eq @ A @ X3 @ Y )
                 => ( ord_less_eq @ B @ ( F @ X3 ) @ ( F @ Y ) ) )
             => ( ord_less_eq @ B @ ( F @ A2 ) @ C2 ) ) ) ) ) ).

% ord_le_eq_subst
thf(fact_160_eq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ^ [Y4: A,Z3: A] : ( Y4 = Z3 ) )
        = ( ^ [X2: A,Y3: A] :
              ( ( ord_less_eq @ A @ X2 @ Y3 )
              & ( ord_less_eq @ A @ Y3 @ X2 ) ) ) ) ) ).

% eq_iff
thf(fact_161_antisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X: A,Y2: A] :
          ( ( ord_less_eq @ A @ X @ Y2 )
         => ( ( ord_less_eq @ A @ Y2 @ X )
           => ( X = Y2 ) ) ) ) ).

% antisym
thf(fact_162_linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y2: A] :
          ( ( ord_less_eq @ A @ X @ Y2 )
          | ( ord_less_eq @ A @ Y2 @ X ) ) ) ).

% linear
thf(fact_163_eq__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y2: A] :
          ( ( X = Y2 )
         => ( ord_less_eq @ A @ X @ Y2 ) ) ) ).

% eq_refl
thf(fact_164_le__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y2: A] :
          ( ~ ( ord_less_eq @ A @ X @ Y2 )
         => ( ord_less_eq @ A @ Y2 @ X ) ) ) ).

% le_cases
thf(fact_165_order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A,C2: A] :
          ( ( ord_less_eq @ A @ A2 @ B3 )
         => ( ( ord_less_eq @ A @ B3 @ C2 )
           => ( ord_less_eq @ A @ A2 @ C2 ) ) ) ) ).

% order.trans
thf(fact_166_le__cases3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y2: A,Z: A] :
          ( ( ( ord_less_eq @ A @ X @ Y2 )
           => ~ ( ord_less_eq @ A @ Y2 @ Z ) )
         => ( ( ( ord_less_eq @ A @ Y2 @ X )
             => ~ ( ord_less_eq @ A @ X @ Z ) )
           => ( ( ( ord_less_eq @ A @ X @ Z )
               => ~ ( ord_less_eq @ A @ Z @ Y2 ) )
             => ( ( ( ord_less_eq @ A @ Z @ Y2 )
                 => ~ ( ord_less_eq @ A @ Y2 @ X ) )
               => ( ( ( ord_less_eq @ A @ Y2 @ Z )
                   => ~ ( ord_less_eq @ A @ Z @ X ) )
                 => ~ ( ( ord_less_eq @ A @ Z @ X )
                     => ~ ( ord_less_eq @ A @ X @ Y2 ) ) ) ) ) ) ) ) ).

% le_cases3
thf(fact_167_antisym__conv,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [Y2: A,X: A] :
          ( ( ord_less_eq @ A @ Y2 @ X )
         => ( ( ord_less_eq @ A @ X @ Y2 )
            = ( X = Y2 ) ) ) ) ).

% antisym_conv
thf(fact_168_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A,C2: A] :
          ( ( A2 = B3 )
         => ( ( ord_less_eq @ A @ B3 @ C2 )
           => ( ord_less_eq @ A @ A2 @ C2 ) ) ) ) ).

% ord_eq_le_trans
thf(fact_169_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A,C2: A] :
          ( ( ord_less_eq @ A @ A2 @ B3 )
         => ( ( B3 = C2 )
           => ( ord_less_eq @ A @ A2 @ C2 ) ) ) ) ).

% ord_le_eq_trans
thf(fact_170_order__class_Oorder_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A] :
          ( ( ord_less_eq @ A @ A2 @ B3 )
         => ( ( ord_less_eq @ A @ B3 @ A2 )
           => ( A2 = B3 ) ) ) ) ).

% order_class.order.antisym
thf(fact_171_order__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y2: A,Z: A] :
          ( ( ord_less_eq @ A @ X @ Y2 )
         => ( ( ord_less_eq @ A @ Y2 @ Z )
           => ( ord_less_eq @ A @ X @ Z ) ) ) ) ).

% order_trans
thf(fact_172_dual__order_Orefl,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A] : ( ord_less_eq @ A @ A2 @ A2 ) ) ).

% dual_order.refl
thf(fact_173_linorder__wlog,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > A > $o,A2: A,B3: A] :
          ( ! [A3: A,B7: A] :
              ( ( ord_less_eq @ A @ A3 @ B7 )
             => ( P @ A3 @ B7 ) )
         => ( ! [A3: A,B7: A] :
                ( ( P @ B7 @ A3 )
               => ( P @ A3 @ B7 ) )
           => ( P @ A2 @ B3 ) ) ) ) ).

% linorder_wlog
thf(fact_174_dual__order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A2: A,C2: A] :
          ( ( ord_less_eq @ A @ B3 @ A2 )
         => ( ( ord_less_eq @ A @ C2 @ B3 )
           => ( ord_less_eq @ A @ C2 @ A2 ) ) ) ) ).

% dual_order.trans
thf(fact_175_dual__order_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A2: A] :
          ( ( ord_less_eq @ A @ B3 @ A2 )
         => ( ( ord_less_eq @ A @ A2 @ B3 )
           => ( A2 = B3 ) ) ) ) ).

% dual_order.antisym
thf(fact_176_set__mp,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A,X: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B2 )
     => ( ( member @ A @ X @ A4 )
       => ( member @ A @ X @ B2 ) ) ) ).

% set_mp
thf(fact_177_in__mono,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A,X: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B2 )
     => ( ( member @ A @ X @ A4 )
       => ( member @ A @ X @ B2 ) ) ) ).

% in_mono
thf(fact_178_subsetD,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A,C2: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B2 )
     => ( ( member @ A @ C2 @ A4 )
       => ( member @ A @ C2 @ B2 ) ) ) ).

% subsetD
thf(fact_179_subsetCE,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A,C2: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B2 )
     => ( ( member @ A @ C2 @ A4 )
       => ( member @ A @ C2 @ B2 ) ) ) ).

% subsetCE
thf(fact_180_equalityE,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A] :
      ( ( A4 = B2 )
     => ~ ( ( ord_less_eq @ ( set @ A ) @ A4 @ B2 )
         => ~ ( ord_less_eq @ ( set @ A ) @ B2 @ A4 ) ) ) ).

% equalityE
thf(fact_181_subset__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A5: set @ A,B5: set @ A] :
          ! [X2: A] :
            ( ( member @ A @ X2 @ A5 )
           => ( member @ A @ X2 @ B5 ) ) ) ) ).

% subset_eq
thf(fact_182_equalityD1,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A] :
      ( ( A4 = B2 )
     => ( ord_less_eq @ ( set @ A ) @ A4 @ B2 ) ) ).

% equalityD1
thf(fact_183_equalityD2,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A] :
      ( ( A4 = B2 )
     => ( ord_less_eq @ ( set @ A ) @ B2 @ A4 ) ) ).

% equalityD2
thf(fact_184_set__rev__mp,axiom,
    ! [A: $tType,X: A,A4: set @ A,B2: set @ A] :
      ( ( member @ A @ X @ A4 )
     => ( ( ord_less_eq @ ( set @ A ) @ A4 @ B2 )
       => ( member @ A @ X @ B2 ) ) ) ).

% set_rev_mp
thf(fact_185_subset__iff,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A5: set @ A,B5: set @ A] :
          ! [T2: A] :
            ( ( member @ A @ T2 @ A5 )
           => ( member @ A @ T2 @ B5 ) ) ) ) ).

% subset_iff
thf(fact_186_rev__subsetD,axiom,
    ! [A: $tType,C2: A,A4: set @ A,B2: set @ A] :
      ( ( member @ A @ C2 @ A4 )
     => ( ( ord_less_eq @ ( set @ A ) @ A4 @ B2 )
       => ( member @ A @ C2 @ B2 ) ) ) ).

% rev_subsetD
thf(fact_187_subset__refl,axiom,
    ! [A: $tType,A4: set @ A] : ( ord_less_eq @ ( set @ A ) @ A4 @ A4 ) ).

% subset_refl
thf(fact_188_Collect__mono,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X3: A] :
          ( ( P @ X3 )
         => ( Q @ X3 ) )
     => ( ord_less_eq @ ( set @ A ) @ ( collect @ A @ P ) @ ( collect @ A @ Q ) ) ) ).

% Collect_mono
thf(fact_189_subset__trans,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A,C: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B2 )
     => ( ( ord_less_eq @ ( set @ A ) @ B2 @ C )
       => ( ord_less_eq @ ( set @ A ) @ A4 @ C ) ) ) ).

% subset_trans
thf(fact_190_set__eq__subset,axiom,
    ! [A: $tType] :
      ( ( ^ [Y4: set @ A,Z3: set @ A] : ( Y4 = Z3 ) )
      = ( ^ [A5: set @ A,B5: set @ A] :
            ( ( ord_less_eq @ ( set @ A ) @ A5 @ B5 )
            & ( ord_less_eq @ ( set @ A ) @ B5 @ A5 ) ) ) ) ).

% set_eq_subset
thf(fact_191_contra__subsetD,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A,C2: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B2 )
     => ( ~ ( member @ A @ C2 @ B2 )
       => ~ ( member @ A @ C2 @ A4 ) ) ) ).

% contra_subsetD
thf(fact_192_Collect__mono__iff,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ( ord_less_eq @ ( set @ A ) @ ( collect @ A @ P ) @ ( collect @ A @ Q ) )
      = ( ! [X2: A] :
            ( ( P @ X2 )
           => ( Q @ X2 ) ) ) ) ).

% Collect_mono_iff
thf(fact_193_double__diff,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A,C: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B2 )
     => ( ( ord_less_eq @ ( set @ A ) @ B2 @ C )
       => ( ( minus_minus @ ( set @ A ) @ B2 @ ( minus_minus @ ( set @ A ) @ C @ A4 ) )
          = A4 ) ) ) ).

% double_diff
thf(fact_194_Diff__subset,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A] : ( ord_less_eq @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A4 @ B2 ) @ A4 ) ).

% Diff_subset
thf(fact_195_Diff__mono,axiom,
    ! [A: $tType,A4: set @ A,C: set @ A,D3: set @ A,B2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ C )
     => ( ( ord_less_eq @ ( set @ A ) @ D3 @ B2 )
       => ( ord_less_eq @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A4 @ B2 ) @ ( minus_minus @ ( set @ A ) @ C @ D3 ) ) ) ) ).

% Diff_mono
thf(fact_196_subset__Un__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A5: set @ A,B5: set @ A] :
            ( ( sup_sup @ ( set @ A ) @ A5 @ B5 )
            = B5 ) ) ) ).

% subset_Un_eq
thf(fact_197_Un__absorb2,axiom,
    ! [A: $tType,B2: set @ A,A4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ B2 @ A4 )
     => ( ( sup_sup @ ( set @ A ) @ A4 @ B2 )
        = A4 ) ) ).

% Un_absorb2
thf(fact_198_Un__absorb1,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B2 )
     => ( ( sup_sup @ ( set @ A ) @ A4 @ B2 )
        = B2 ) ) ).

% Un_absorb1
thf(fact_199_Un__upper2,axiom,
    ! [A: $tType,B2: set @ A,A4: set @ A] : ( ord_less_eq @ ( set @ A ) @ B2 @ ( sup_sup @ ( set @ A ) @ A4 @ B2 ) ) ).

% Un_upper2
thf(fact_200_Un__upper1,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A] : ( ord_less_eq @ ( set @ A ) @ A4 @ ( sup_sup @ ( set @ A ) @ A4 @ B2 ) ) ).

% Un_upper1
thf(fact_201_Un__least,axiom,
    ! [A: $tType,A4: set @ A,C: set @ A,B2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ C )
     => ( ( ord_less_eq @ ( set @ A ) @ B2 @ C )
       => ( ord_less_eq @ ( set @ A ) @ ( sup_sup @ ( set @ A ) @ A4 @ B2 ) @ C ) ) ) ).

% Un_least
thf(fact_202_Un__mono,axiom,
    ! [A: $tType,A4: set @ A,C: set @ A,B2: set @ A,D3: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ C )
     => ( ( ord_less_eq @ ( set @ A ) @ B2 @ D3 )
       => ( ord_less_eq @ ( set @ A ) @ ( sup_sup @ ( set @ A ) @ A4 @ B2 ) @ ( sup_sup @ ( set @ A ) @ C @ D3 ) ) ) ) ).

% Un_mono
thf(fact_203_subset__insertI2,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A,B3: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B2 )
     => ( ord_less_eq @ ( set @ A ) @ A4 @ ( insert @ A @ B3 @ B2 ) ) ) ).

% subset_insertI2
thf(fact_204_subset__insertI,axiom,
    ! [A: $tType,B2: set @ A,A2: A] : ( ord_less_eq @ ( set @ A ) @ B2 @ ( insert @ A @ A2 @ B2 ) ) ).

% subset_insertI
thf(fact_205_subset__insert,axiom,
    ! [A: $tType,X: A,A4: set @ A,B2: set @ A] :
      ( ~ ( member @ A @ X @ A4 )
     => ( ( ord_less_eq @ ( set @ A ) @ A4 @ ( insert @ A @ X @ B2 ) )
        = ( ord_less_eq @ ( set @ A ) @ A4 @ B2 ) ) ) ).

% subset_insert
thf(fact_206_insert__mono,axiom,
    ! [A: $tType,C: set @ A,D3: set @ A,A2: A] :
      ( ( ord_less_eq @ ( set @ A ) @ C @ D3 )
     => ( ord_less_eq @ ( set @ A ) @ ( insert @ A @ A2 @ C ) @ ( insert @ A @ A2 @ D3 ) ) ) ).

% insert_mono
thf(fact_207_sup_OcoboundedI2,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [C2: A,B3: A,A2: A] :
          ( ( ord_less_eq @ A @ C2 @ B3 )
         => ( ord_less_eq @ A @ C2 @ ( sup_sup @ A @ A2 @ B3 ) ) ) ) ).

% sup.coboundedI2
thf(fact_208_sup_OcoboundedI1,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [C2: A,A2: A,B3: A] :
          ( ( ord_less_eq @ A @ C2 @ A2 )
         => ( ord_less_eq @ A @ C2 @ ( sup_sup @ A @ A2 @ B3 ) ) ) ) ).

% sup.coboundedI1
thf(fact_209_sup_Oabsorb__iff2,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [A6: A,B6: A] :
              ( ( sup_sup @ A @ A6 @ B6 )
              = B6 ) ) ) ) ).

% sup.absorb_iff2
thf(fact_210_sup_Oabsorb__iff1,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [B6: A,A6: A] :
              ( ( sup_sup @ A @ A6 @ B6 )
              = A6 ) ) ) ) ).

% sup.absorb_iff1
thf(fact_211_sup_Ocobounded2,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [B3: A,A2: A] : ( ord_less_eq @ A @ B3 @ ( sup_sup @ A @ A2 @ B3 ) ) ) ).

% sup.cobounded2
thf(fact_212_sup_Ocobounded1,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A] : ( ord_less_eq @ A @ A2 @ ( sup_sup @ A @ A2 @ B3 ) ) ) ).

% sup.cobounded1
thf(fact_213_sup_Oorder__iff,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [B6: A,A6: A] :
              ( A6
              = ( sup_sup @ A @ A6 @ B6 ) ) ) ) ) ).

% sup.order_iff
thf(fact_214_sup_OboundedI,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [B3: A,A2: A,C2: A] :
          ( ( ord_less_eq @ A @ B3 @ A2 )
         => ( ( ord_less_eq @ A @ C2 @ A2 )
           => ( ord_less_eq @ A @ ( sup_sup @ A @ B3 @ C2 ) @ A2 ) ) ) ) ).

% sup.boundedI
thf(fact_215_sup_OboundedE,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [B3: A,C2: A,A2: A] :
          ( ( ord_less_eq @ A @ ( sup_sup @ A @ B3 @ C2 ) @ A2 )
         => ~ ( ( ord_less_eq @ A @ B3 @ A2 )
             => ~ ( ord_less_eq @ A @ C2 @ A2 ) ) ) ) ).

% sup.boundedE
thf(fact_216_sup__absorb2,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [X: A,Y2: A] :
          ( ( ord_less_eq @ A @ X @ Y2 )
         => ( ( sup_sup @ A @ X @ Y2 )
            = Y2 ) ) ) ).

% sup_absorb2
thf(fact_217_sup__absorb1,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [Y2: A,X: A] :
          ( ( ord_less_eq @ A @ Y2 @ X )
         => ( ( sup_sup @ A @ X @ Y2 )
            = X ) ) ) ).

% sup_absorb1
thf(fact_218_sup_Oabsorb2,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A] :
          ( ( ord_less_eq @ A @ A2 @ B3 )
         => ( ( sup_sup @ A @ A2 @ B3 )
            = B3 ) ) ) ).

% sup.absorb2
thf(fact_219_sup_Oabsorb1,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [B3: A,A2: A] :
          ( ( ord_less_eq @ A @ B3 @ A2 )
         => ( ( sup_sup @ A @ A2 @ B3 )
            = A2 ) ) ) ).

% sup.absorb1
thf(fact_220_sup__unique,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [F: A > A > A,X: A,Y2: A] :
          ( ! [X3: A,Y: A] : ( ord_less_eq @ A @ X3 @ ( F @ X3 @ Y ) )
         => ( ! [X3: A,Y: A] : ( ord_less_eq @ A @ Y @ ( F @ X3 @ Y ) )
           => ( ! [X3: A,Y: A,Z4: A] :
                  ( ( ord_less_eq @ A @ Y @ X3 )
                 => ( ( ord_less_eq @ A @ Z4 @ X3 )
                   => ( ord_less_eq @ A @ ( F @ Y @ Z4 ) @ X3 ) ) )
             => ( ( sup_sup @ A @ X @ Y2 )
                = ( F @ X @ Y2 ) ) ) ) ) ) ).

% sup_unique
thf(fact_221_sup_OorderI,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A] :
          ( ( A2
            = ( sup_sup @ A @ A2 @ B3 ) )
         => ( ord_less_eq @ A @ B3 @ A2 ) ) ) ).

% sup.orderI
thf(fact_222_sup_OorderE,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [B3: A,A2: A] :
          ( ( ord_less_eq @ A @ B3 @ A2 )
         => ( A2
            = ( sup_sup @ A @ A2 @ B3 ) ) ) ) ).

% sup.orderE
thf(fact_223_le__iff__sup,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [X2: A,Y3: A] :
              ( ( sup_sup @ A @ X2 @ Y3 )
              = Y3 ) ) ) ) ).

% le_iff_sup
thf(fact_224_sup__least,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [Y2: A,X: A,Z: A] :
          ( ( ord_less_eq @ A @ Y2 @ X )
         => ( ( ord_less_eq @ A @ Z @ X )
           => ( ord_less_eq @ A @ ( sup_sup @ A @ Y2 @ Z ) @ X ) ) ) ) ).

% sup_least
thf(fact_225_sup__mono,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [A2: A,C2: A,B3: A,D: A] :
          ( ( ord_less_eq @ A @ A2 @ C2 )
         => ( ( ord_less_eq @ A @ B3 @ D )
           => ( ord_less_eq @ A @ ( sup_sup @ A @ A2 @ B3 ) @ ( sup_sup @ A @ C2 @ D ) ) ) ) ) ).

% sup_mono
thf(fact_226_sup_Omono,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [C2: A,A2: A,D: A,B3: A] :
          ( ( ord_less_eq @ A @ C2 @ A2 )
         => ( ( ord_less_eq @ A @ D @ B3 )
           => ( ord_less_eq @ A @ ( sup_sup @ A @ C2 @ D ) @ ( sup_sup @ A @ A2 @ B3 ) ) ) ) ) ).

% sup.mono
thf(fact_227_le__supI2,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [X: A,B3: A,A2: A] :
          ( ( ord_less_eq @ A @ X @ B3 )
         => ( ord_less_eq @ A @ X @ ( sup_sup @ A @ A2 @ B3 ) ) ) ) ).

% le_supI2
thf(fact_228_le__supI1,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [X: A,A2: A,B3: A] :
          ( ( ord_less_eq @ A @ X @ A2 )
         => ( ord_less_eq @ A @ X @ ( sup_sup @ A @ A2 @ B3 ) ) ) ) ).

% le_supI1
thf(fact_229_sup__ge2,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [Y2: A,X: A] : ( ord_less_eq @ A @ Y2 @ ( sup_sup @ A @ X @ Y2 ) ) ) ).

% sup_ge2
thf(fact_230_sup__ge1,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [X: A,Y2: A] : ( ord_less_eq @ A @ X @ ( sup_sup @ A @ X @ Y2 ) ) ) ).

% sup_ge1
thf(fact_231_le__supI,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [A2: A,X: A,B3: A] :
          ( ( ord_less_eq @ A @ A2 @ X )
         => ( ( ord_less_eq @ A @ B3 @ X )
           => ( ord_less_eq @ A @ ( sup_sup @ A @ A2 @ B3 ) @ X ) ) ) ) ).

% le_supI
thf(fact_232_le__supE,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A,X: A] :
          ( ( ord_less_eq @ A @ ( sup_sup @ A @ A2 @ B3 ) @ X )
         => ~ ( ( ord_less_eq @ A @ A2 @ X )
             => ~ ( ord_less_eq @ A @ B3 @ X ) ) ) ) ).

% le_supE
thf(fact_233_inf__sup__ord_I3_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X: A,Y2: A] : ( ord_less_eq @ A @ X @ ( sup_sup @ A @ X @ Y2 ) ) ) ).

% inf_sup_ord(3)
thf(fact_234_inf__sup__ord_I4_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [Y2: A,X: A] : ( ord_less_eq @ A @ Y2 @ ( sup_sup @ A @ X @ Y2 ) ) ) ).

% inf_sup_ord(4)
thf(fact_235_pairwise__subset,axiom,
    ! [A: $tType,P: A > A > $o,S3: set @ A,T3: set @ A] :
      ( ( pairwise @ A @ P @ S3 )
     => ( ( ord_less_eq @ ( set @ A ) @ T3 @ S3 )
       => ( pairwise @ A @ P @ T3 ) ) ) ).

% pairwise_subset
thf(fact_236_subset__singletonD,axiom,
    ! [A: $tType,A4: set @ A,X: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) )
     => ( ( A4
          = ( bot_bot @ ( set @ A ) ) )
        | ( A4
          = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% subset_singletonD
thf(fact_237_subset__singleton__iff,axiom,
    ! [A: $tType,X4: set @ A,A2: A] :
      ( ( ord_less_eq @ ( set @ A ) @ X4 @ ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) )
      = ( ( X4
          = ( bot_bot @ ( set @ A ) ) )
        | ( X4
          = ( insert @ A @ A2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% subset_singleton_iff
thf(fact_238_subset__Diff__insert,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A,X: A,C: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ ( minus_minus @ ( set @ A ) @ B2 @ ( insert @ A @ X @ C ) ) )
      = ( ( ord_less_eq @ ( set @ A ) @ A4 @ ( minus_minus @ ( set @ A ) @ B2 @ C ) )
        & ~ ( member @ A @ X @ A4 ) ) ) ).

% subset_Diff_insert
thf(fact_239_Diff__partition,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B2 )
     => ( ( sup_sup @ ( set @ A ) @ A4 @ ( minus_minus @ ( set @ A ) @ B2 @ A4 ) )
        = B2 ) ) ).

% Diff_partition
thf(fact_240_Diff__subset__conv,axiom,
    ! [A: $tType,A4: set @ A,B2: set @ A,C: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A4 @ B2 ) @ C )
      = ( ord_less_eq @ ( set @ A ) @ A4 @ ( sup_sup @ ( set @ A ) @ B2 @ C ) ) ) ).

% Diff_subset_conv
thf(fact_241_insert__subsetI,axiom,
    ! [A: $tType,X: A,A4: set @ A,X4: set @ A] :
      ( ( member @ A @ X @ A4 )
     => ( ( ord_less_eq @ ( set @ A ) @ X4 @ A4 )
       => ( ord_less_eq @ ( set @ A ) @ ( insert @ A @ X @ X4 ) @ A4 ) ) ) ).

% insert_subsetI
thf(fact_242_subset__emptyI,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ! [X3: A] :
          ~ ( member @ A @ X3 @ A4 )
     => ( ord_less_eq @ ( set @ A ) @ A4 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% subset_emptyI
thf(fact_243_monoid__def,axiom,
    ! [A: $tType] :
      ( ( monoid @ A )
      = ( ^ [F2: A > A > A,Z2: A] :
            ( ( semigroup @ A @ F2 )
            & ( monoid_axioms @ A @ F2 @ Z2 ) ) ) ) ).

% monoid_def
thf(fact_244_monoid_Ointro,axiom,
    ! [A: $tType,F: A > A > A,Z: A] :
      ( ( semigroup @ A @ F )
     => ( ( monoid_axioms @ A @ F @ Z )
       => ( monoid @ A @ F @ Z ) ) ) ).

% monoid.intro
thf(fact_245_semigroup_Ointro,axiom,
    ! [A: $tType,F: A > A > A] :
      ( ! [A3: A,B7: A,C5: A] :
          ( ( F @ ( F @ A3 @ B7 ) @ C5 )
          = ( F @ A3 @ ( F @ B7 @ C5 ) ) )
     => ( semigroup @ A @ F ) ) ).

% semigroup.intro
thf(fact_246_semigroup_Oassoc,axiom,
    ! [A: $tType,F: A > A > A,A2: A,B3: A,C2: A] :
      ( ( semigroup @ A @ F )
     => ( ( F @ ( F @ A2 @ B3 ) @ C2 )
        = ( F @ A2 @ ( F @ B3 @ C2 ) ) ) ) ).

% semigroup.assoc
thf(fact_247_semigroup__def,axiom,
    ! [A: $tType] :
      ( ( semigroup @ A )
      = ( ^ [F2: A > A > A] :
          ! [A6: A,B6: A,C6: A] :
            ( ( F2 @ ( F2 @ A6 @ B6 ) @ C6 )
            = ( F2 @ A6 @ ( F2 @ B6 @ C6 ) ) ) ) ) ).

% semigroup_def
thf(fact_248_sup_Osemigroup__axioms,axiom,
    ! [A: $tType] :
      ( ( semilattice_sup @ A @ ( type2 @ A ) )
     => ( semigroup @ A @ ( sup_sup @ A ) ) ) ).

% sup.semigroup_axioms
thf(fact_249_monoid_Oaxioms_I1_J,axiom,
    ! [A: $tType,F: A > A > A,Z: A] :
      ( ( monoid @ A @ F @ Z )
     => ( semigroup @ A @ F ) ) ).

% monoid.axioms(1)
thf(fact_250_psubset__insert__iff,axiom,
    ! [A: $tType,A4: set @ A,X: A,B2: set @ A] :
      ( ( ord_less @ ( set @ A ) @ A4 @ ( insert @ A @ X @ B2 ) )
      = ( ( ( member @ A @ X @ B2 )
         => ( ord_less @ ( set @ A ) @ A4 @ B2 ) )
        & ( ~ ( member @ A @ X @ B2 )
         => ( ( ( member @ A @ X @ A4 )
             => ( ord_less @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A4 @ ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) @ B2 ) )
            & ( ~ ( member @ A @ X @ A4 )
             => ( ord_less_eq @ ( set @ A ) @ A4 @ B2 ) ) ) ) ) ) ).

% psubset_insert_iff
thf(fact_251_subset__Compl__singleton,axiom,
    ! [A: $tType,A4: set @ A,B3: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ ( uminus_uminus @ ( set @ A ) @ ( insert @ A @ B3 @ ( bot_bot @ ( set @ A ) ) ) ) )
      = ( ~ ( member @ A @ B3 @ A4 ) ) ) ).

% subset_Compl_singleton
thf(fact_252_add_Oinverse__inverse,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( uminus_uminus @ A @ ( uminus_uminus @ A @ A2 ) )
          = A2 ) ) ).

% add.inverse_inverse
thf(fact_253_neg__equal__iff__equal,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A] :
          ( ( ( uminus_uminus @ A @ A2 )
            = ( uminus_uminus @ A @ B3 ) )
          = ( A2 = B3 ) ) ) ).

% neg_equal_iff_equal
thf(fact_254_uminus__apply,axiom,
    ! [B: $tType,A: $tType] :
      ( ( uminus @ B @ ( type2 @ B ) )
     => ( ( uminus_uminus @ ( A > B ) )
        = ( ^ [A5: A > B,X2: A] : ( uminus_uminus @ B @ ( A5 @ X2 ) ) ) ) ) ).

% uminus_apply
thf(fact_255_double__compl,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A @ ( type2 @ A ) )
     => ! [X: A] :
          ( ( uminus_uminus @ A @ ( uminus_uminus @ A @ X ) )
          = X ) ) ).

% double_compl

%----Type constructors (50)
thf(tcon_HOL_Obool___Lattices_Obounded__lattice,axiom,
    bounded_lattice @ $o @ ( type2 @ $o ) ).

thf(tcon_Set_Oset___Lattices_Obounded__lattice_1,axiom,
    ! [A7: $tType] : ( bounded_lattice @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_fun___Lattices_Obounded__lattice_2,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( bounded_lattice @ A8 @ ( type2 @ A8 ) )
     => ( bounded_lattice @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Lattices_Obounded__semilattice__sup__bot,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( bounded_lattice @ A8 @ ( type2 @ A8 ) )
     => ( bounde1808546759up_bot @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Lattices_Obounded__lattice__bot,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( bounded_lattice @ A8 @ ( type2 @ A8 ) )
     => ( bounded_lattice_bot @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Lattices_Osemilattice__sup,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( semilattice_sup @ A8 @ ( type2 @ A8 ) )
     => ( semilattice_sup @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Lattices_Oboolean__algebra,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( boolean_algebra @ A8 @ ( type2 @ A8 ) )
     => ( boolean_algebra @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Orderings_Oorder__bot,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( order_bot @ A8 @ ( type2 @ A8 ) )
     => ( order_bot @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Orderings_Opreorder,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( preorder @ A8 @ ( type2 @ A8 ) )
     => ( preorder @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Lattices_Olattice,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( lattice @ A8 @ ( type2 @ A8 ) )
     => ( lattice @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Orderings_Oorder,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( order @ A8 @ ( type2 @ A8 ) )
     => ( order @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Orderings_Oord,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( ord @ A8 @ ( type2 @ A8 ) )
     => ( ord @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Orderings_Obot,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( bot @ A8 @ ( type2 @ A8 ) )
     => ( bot @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Groups_Ouminus,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( uminus @ A8 @ ( type2 @ A8 ) )
     => ( uminus @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Groups_Ominus,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( minus @ A8 @ ( type2 @ A8 ) )
     => ( minus @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Lattices_Osemilattice__sup_3,axiom,
    semilattice_sup @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Oorder__bot_4,axiom,
    order_bot @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Opreorder_5,axiom,
    preorder @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Olinorder,axiom,
    linorder @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Lattices_Olattice_6,axiom,
    lattice @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Oorder_7,axiom,
    order @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Oord_8,axiom,
    ord @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Obot_9,axiom,
    bot @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ominus_10,axiom,
    minus @ nat @ ( type2 @ nat ) ).

thf(tcon_Set_Oset___Lattices_Obounded__semilattice__sup__bot_11,axiom,
    ! [A7: $tType] : ( bounde1808546759up_bot @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Lattices_Obounded__lattice__bot_12,axiom,
    ! [A7: $tType] : ( bounded_lattice_bot @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Lattices_Osemilattice__sup_13,axiom,
    ! [A7: $tType] : ( semilattice_sup @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Lattices_Oboolean__algebra_14,axiom,
    ! [A7: $tType] : ( boolean_algebra @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder__bot_15,axiom,
    ! [A7: $tType] : ( order_bot @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Opreorder_16,axiom,
    ! [A7: $tType] : ( preorder @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Lattices_Olattice_17,axiom,
    ! [A7: $tType] : ( lattice @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder_18,axiom,
    ! [A7: $tType] : ( order @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oord_19,axiom,
    ! [A7: $tType] : ( ord @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Obot_20,axiom,
    ! [A7: $tType] : ( bot @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Groups_Ouminus_21,axiom,
    ! [A7: $tType] : ( uminus @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Groups_Ominus_22,axiom,
    ! [A7: $tType] : ( minus @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_HOL_Obool___Lattices_Obounded__semilattice__sup__bot_23,axiom,
    bounde1808546759up_bot @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Lattices_Obounded__lattice__bot_24,axiom,
    bounded_lattice_bot @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Lattices_Osemilattice__sup_25,axiom,
    semilattice_sup @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Lattices_Oboolean__algebra_26,axiom,
    boolean_algebra @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oorder__bot_27,axiom,
    order_bot @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Opreorder_28,axiom,
    preorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Olinorder_29,axiom,
    linorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Lattices_Olattice_30,axiom,
    lattice @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oorder_31,axiom,
    order @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oord_32,axiom,
    ord @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Obot_33,axiom,
    bot @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Groups_Ouminus_34,axiom,
    uminus @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Groups_Ominus_35,axiom,
    minus @ $o @ ( type2 @ $o ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    ( ( ( member @ a @ a2 @ ( huffma505251170phabet @ a @ t ) )
     => ( ( ( member @ a @ b @ ( huffma505251170phabet @ a @ t ) )
         => ( ( huffma505251170phabet @ a @ ( huffma2094459102Leaves @ a @ t @ w_a @ a2 @ w_b @ b ) )
            = ( huffma505251170phabet @ a @ t ) ) )
        & ( ~ ( member @ a @ b @ ( huffma505251170phabet @ a @ t ) )
         => ( ( huffma505251170phabet @ a @ ( huffma2094459102Leaves @ a @ t @ w_a @ a2 @ w_b @ b ) )
            = ( sup_sup @ ( set @ a ) @ ( minus_minus @ ( set @ a ) @ ( huffma505251170phabet @ a @ t ) @ ( insert @ a @ a2 @ ( bot_bot @ ( set @ a ) ) ) ) @ ( insert @ a @ b @ ( bot_bot @ ( set @ a ) ) ) ) ) ) ) )
    & ( ~ ( member @ a @ a2 @ ( huffma505251170phabet @ a @ t ) )
     => ( ( ( member @ a @ b @ ( huffma505251170phabet @ a @ t ) )
         => ( ( huffma505251170phabet @ a @ ( huffma2094459102Leaves @ a @ t @ w_a @ a2 @ w_b @ b ) )
            = ( sup_sup @ ( set @ a ) @ ( minus_minus @ ( set @ a ) @ ( huffma505251170phabet @ a @ t ) @ ( insert @ a @ b @ ( bot_bot @ ( set @ a ) ) ) ) @ ( insert @ a @ a2 @ ( bot_bot @ ( set @ a ) ) ) ) ) )
        & ( ~ ( member @ a @ b @ ( huffma505251170phabet @ a @ t ) )
         => ( ( huffma505251170phabet @ a @ ( huffma2094459102Leaves @ a @ t @ w_a @ a2 @ w_b @ b ) )
            = ( huffma505251170phabet @ a @ t ) ) ) ) ) ) ).

%------------------------------------------------------------------------------
